/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rescrcon;

import com.ibm.hwmca.base.rescrcon.Actbrst;
import com.ibm.hwmca.base.rescrcon.RestoreCriticalConsoleDataResourceBundle;
import com.ibm.hwmca.base.rescrcon.RestoreErrorIds;
import com.ibm.hwmca.base.rescrcon.RestoreException;
import com.ibm.hwmca.base.rescrcon.RestoreParameterKeys;
import com.ibm.hwmca.base.rescrcon.RestoreParameters;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.mediasvc.InvalidFileSystemException;
import com.ibm.hwmca.fw.mediasvc.MediaDevice;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceIdentifier;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceLockException;
import com.ibm.hwmca.fw.mediasvc.MediaServices;
import com.ibm.hwmca.fw.mediasvc.MediaWriteProtectedException;
import com.ibm.hwmca.fw.mediasvc.NoMediaPresentException;
import com.ibm.hwmca.fw.report.CompletionReport;
import com.ibm.hwmca.fw.report.CompletionReportCode;
import com.ibm.hwmca.fw.task.ProgressReportListenerImpl;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.IOException;

class RestoreImpl
implements RestoreErrorIds,
RestoreParameterKeys {
    private static final String TRACE_MASKT = "XRCCIMPT";
    private static final String TRACE_MASKF = "XRCCIMPF";
    private static final String TRACE_MASKD = "XRCCIMPD";
    private RestoreParameters restoreParameters = null;
    private MediaDevice restoreDevice = null;
    private LocalizableText mediaName = null;
    private int returnState;
    private Actbrst hdAct = null;
    private Actbrst tarAct = null;
    private boolean wrongEC = false;
    private boolean wrongVer = false;

    RestoreImpl() {
        Trace.trace(TRACE_MASKT, "-> RestoreImpl.RestoreImpl()");
        this.restoreParameters = RestoreParameters.getRestoreParameters();
        Trace.trace(TRACE_MASKT, "<- RestoreImpl.RestoreImpl()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    boolean isRestoreNeeded() throws RestoreException {
        boolean doRestore;
        block23: {
            Trace.trace(TRACE_MASKT, "-> RestoreImpl.isRestoreNeeded()");
            MediaDevice upgradeDevice = null;
            doRestore = false;
            MediaServices ms = MediaServices.getMediaServices();
            MediaDeviceIdentifier upgradeMediaId = ms.getPreferredDevice(4);
            upgradeDevice = ms.requestLock(new LocalizableText("Restore Critical Console Data"), upgradeMediaId);
            Trace.trace(TRACE_MASKF, "Mountpoint is: " + upgradeDevice.getMountPoint().toString());
            Trace.trace(TRACE_MASKF, "Upgrade partition is: " + this.restoreParameters.getParm("upgrade.partition"));
            if (!upgradeDevice.getMountPoint().toString().equals(this.restoreParameters.getParm("upgrade.partition"))) {
                throw new RestoreException("wrong partition");
            }
            upgradeDevice.mountReadOnly();
            File flagFileL = new File(this.restoreParameters.getParm("upgrade.partition") + "/" + this.restoreParameters.getParm("restore.flag").toLowerCase());
            Trace.trace(TRACE_MASKF, "flag file lower case name is: " + flagFileL.getAbsolutePath());
            File flagFileU = new File(this.restoreParameters.getParm("upgrade.partition") + "/" + this.restoreParameters.getParm("restore.flag").toUpperCase());
            Trace.trace(TRACE_MASKF, "flag file upper case name is: " + flagFileU.getAbsolutePath());
            if (flagFileL.exists() || flagFileU.exists()) {
                doRestore = true;
                Trace.trace(TRACE_MASKF, "Need to do a restore");
            } else {
                Trace.trace(TRACE_MASKF, "No need to do a restore");
            }
            this.returnState = 0;
            Object var8_21 = null;
            Trace.trace(TRACE_MASKF, "doing final release");
            try {
                if (upgradeDevice != null) {
                    this.releaseLock(upgradeDevice);
                }
                break block23;
            }
            catch (Exception exc) {
                this.returnState = 1;
                RestoreException rexc = new RestoreException(exc);
                new FrameworkLog(RestoreErrorIds._logInfo, 517, rexc).log();
            }
            break block23;
            {
                catch (IllegalArgumentException e) {
                    Trace.trace(TRACE_MASKF, "caught illegal argument exception: " + e.getMessage());
                    Object var8_22 = null;
                    Trace.trace(TRACE_MASKF, "doing final release");
                    try {
                        if (upgradeDevice != null) {
                            this.releaseLock(upgradeDevice);
                        }
                        break block23;
                    }
                    catch (Exception exc) {
                        this.returnState = 1;
                        RestoreException rexc = new RestoreException(exc);
                        new FrameworkLog(RestoreErrorIds._logInfo, 517, rexc).log();
                    }
                    break block23;
                }
                catch (MediaDeviceLockException e) {
                    this.returnState = 1;
                    Trace.trace(TRACE_MASKF, "caught media device lock exception: " + e.getMessage());
                    RestoreException rexc = new RestoreException(e);
                    throw rexc;
                }
                catch (MediaWriteProtectedException e) {
                    this.returnState = 2;
                    Trace.trace(TRACE_MASKF, "caught media write protected exception: " + e.getMessage());
                    RestoreException rexc = new RestoreException(e);
                    throw rexc;
                }
                catch (NoMediaPresentException e) {
                    this.returnState = 3;
                    Trace.trace(TRACE_MASKF, "caught no media present exception: " + e.getMessage());
                    RestoreException rexc = new RestoreException(e);
                    throw rexc;
                }
                catch (InvalidFileSystemException e) {
                    this.returnState = 7;
                    Trace.trace(TRACE_MASKF, "caught invalid file system exception: " + e.getMessage());
                    RestoreException rexc = new RestoreException(e);
                    throw rexc;
                }
                catch (MediaDeviceException e) {
                    this.returnState = 4;
                    Trace.trace(TRACE_MASKF, "caught general media device exception: " + e.getMessage());
                    RestoreException rexc = new RestoreException(e);
                    new FrameworkLog(RestoreErrorIds._logInfo, 517, rexc).log();
                    throw rexc;
                }
                catch (RestoreException e) {
                    this.returnState = 5;
                    Trace.trace(TRACE_MASKF, "caught restore exception: " + e.getMessage());
                    RestoreException rexc = new RestoreException(e);
                    throw rexc;
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "caught unknown exception: " + e.getMessage());
                    this.returnState = 4;
                    Object var8_23 = null;
                    Trace.trace(TRACE_MASKF, "doing final release");
                    try {
                        if (upgradeDevice != null) {
                            this.releaseLock(upgradeDevice);
                        }
                        break block23;
                    }
                    catch (Exception exc) {
                        this.returnState = 1;
                        RestoreException rexc = new RestoreException(exc);
                        new FrameworkLog(RestoreErrorIds._logInfo, 517, rexc).log();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_24 = null;
                Trace.trace(TRACE_MASKF, "doing final release");
                try {
                    if (upgradeDevice != null) {
                        this.releaseLock(upgradeDevice);
                    }
                }
                catch (Exception exc) {
                    this.returnState = 1;
                    RestoreException rexc = new RestoreException(exc);
                    new FrameworkLog(RestoreErrorIds._logInfo, 517, rexc).log();
                }
                throw throwable;
            }
        }
        Trace.trace(TRACE_MASKT, "<- RestoreImpl.isRestoreNeeded()");
        return doRestore;
    }

    synchronized void restorePreparation() throws RestoreException {
        Trace.trace(TRACE_MASKT, "-> RestoreImpl.restorePreparation()");
        try {
            this.loadRestoreMedia();
            this.checkECVer();
            if (this.wrongEC || this.wrongVer) {
                LocalizableText errorMsgSuffix = new LocalizableText("com/ibm/hwmca/base/rescrcon/res/restoreres", "restore.ecver.error");
                String errorMsgString = "";
                String eoln = "\n";
                if (this.wrongEC) {
                    LocalizableText errorMsgEC = new LocalizableText("com/ibm/hwmca/base/rescrcon/res/restoreres", "restore.ec.error");
                    errorMsgString = errorMsgEC.toString() + " " + this.tarAct.getEC() + " " + errorMsgSuffix.toString() + " " + this.hdAct.getEC();
                    this.returnState = 9;
                }
                if (this.wrongVer) {
                    LocalizableText errorMsgVer = new LocalizableText("com/ibm/hwmca/base/rescrcon/res/restoreres", "restore.ver.error");
                    if (this.wrongEC) {
                        errorMsgString = errorMsgString + eoln;
                    }
                    errorMsgString = errorMsgString + errorMsgVer.toString() + " " + this.tarAct.getVER() + " " + errorMsgSuffix.toString() + " " + this.hdAct.getVER();
                    this.returnState = 10;
                }
                if (this.wrongEC && this.wrongVer) {
                    this.returnState = 11;
                }
                throw new RestoreException(errorMsgString);
            }
            Trace.trace(TRACE_MASKF, "EC and Versions match");
            this.returnState = 0;
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, "Exception during restore preparation: " + exc);
            this.releaseLock(this.restoreDevice);
            throw new RestoreException(exc);
        }
        Trace.trace(TRACE_MASKT, "<- RestoreImpl.restorePreparation()");
    }

    private void loadRestoreMedia() throws RestoreException {
        try {
            MediaServices ms = MediaServices.getMediaServices();
            MediaDeviceIdentifier restoreMediaId = ms.getPreferredDevice(6);
            this.mediaName = ms.getMediaDisplayableName(6);
            this.restoreDevice = ms.requestLock(new LocalizableText("Restore Critical Console Data"), restoreMediaId);
            if (this.restoreDevice.getLabel() == null) {
                throw new RestoreException("wrong label: " + this.restoreDevice.getLabel());
            }
            if (!this.restoreDevice.getLabel().equals("ACTBKP")) {
                this.returnState = 5;
                throw new RestoreException("wrong label: " + this.restoreDevice.getLabel());
            }
            this.restoreDevice.mountReadOnly();
            this.returnState = 0;
        }
        catch (IllegalArgumentException e) {
        }
        catch (MediaDeviceLockException e) {
            this.returnState = 1;
            RestoreException rexc = new RestoreException(e);
            throw rexc;
        }
        catch (NoMediaPresentException e) {
            this.returnState = 3;
            RestoreException rexc = new RestoreException(e);
            throw rexc;
        }
        catch (InvalidFileSystemException e) {
            this.returnState = 7;
            RestoreException rexc = new RestoreException(e);
            throw rexc;
        }
        catch (MediaDeviceException e) {
            this.returnState = 4;
            RestoreException rexc = new RestoreException(e);
            new FrameworkLog(RestoreErrorIds._logInfo, 517, rexc).log();
            throw rexc;
        }
        catch (RestoreException rexc) {
            this.returnState = 5;
            throw rexc;
        }
    }

    private void checkECVer() throws RestoreException {
        Trace.trace(TRACE_MASKF, "-> RestoreImpl.checkECVer()");
        String actbrst = this.restoreParameters.getParm("restore.data.dir") + "/" + this.restoreParameters.getParm("restore.actbrst");
        String[] cmd = new String[4];
        cmd[0] = this.restoreParameters.getParm("restore.getactbrst.script");
        cmd[2] = actbrst;
        cmd[3] = this.restoreParameters.getParm("restore.data.dir") + "/" + this.restoreParameters.getParm("restore.log");
        try {
            cmd[1] = this.restoreDevice.getMountPoint().getAbsolutePath() + "/" + this.restoreParameters.getParm("restore.archive");
            int rc = RootProcess.executeProgram(cmd);
            Trace.trace(TRACE_MASKF, cmd[0] + " completed with rc=" + rc);
            this.hdAct = new Actbrst(actbrst);
            this.tarAct = new Actbrst("/tmp/" + actbrst);
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, "checkECVer: " + exc.getMessage());
            throw new RestoreException(exc);
        }
        this.wrongEC = !this.hdAct.getEC().equals(this.tarAct.getEC());
        this.wrongVer = !this.hdAct.getVER().equals(this.tarAct.getVER());
        Trace.trace(TRACE_MASKF, "<- RestoreImpl.checkECVer()");
    }

    synchronized void restore(ProgressReportListenerImpl restoreListener) throws RestoreException {
        block8: {
            Trace.trace(TRACE_MASKT, "-> RestoreImpl.restore()");
            String flagFileDeleted = " ";
            String[] cmd = new String[3];
            cmd[0] = this.restoreParameters.getParm("restore.script");
            cmd[2] = this.restoreParameters.getParm("restore.data.dir") + "/" + this.restoreParameters.getParm("restore.log");
            try {
                cmd[1] = this.restoreDevice.getMountPoint().getAbsolutePath() + "/" + this.restoreParameters.getParm("restore.archive");
                int rc = RootProcess.executeProgram(cmd);
                Trace.trace(TRACE_MASKF, cmd[0] + " completed with rc=" + rc);
                this.restoreDevice.unmount();
                String reportStr = null;
                if (rc == 0) {
                    this.returnState = 0;
                    if (!this.deleteFlagFile()) {
                        flagFileDeleted = new LocalizableText("com/ibm/hwmca/base/rescrcon/res/restoreres", RestoreCriticalConsoleDataResourceBundle.RestoreErrors(13)).toString();
                    }
                    reportStr = "Restore Successful" + flagFileDeleted;
                    CompletionReport report = new CompletionReport(new ObjectId(this), CompletionReportCode.SUCCESS, reportStr);
                    restoreListener.finished(report);
                    break block8;
                }
                if (rc == 1) {
                    throw new IOException("utar failed");
                }
                throw new IOException("unknown error");
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, "restore(): " + exc.getMessage());
                BaseMessageText bmt = new BaseMessageText("RES00007");
                CompletionReport report = new CompletionReport(new ObjectId(this), CompletionReportCode.FAIL, bmt.toString());
                restoreListener.finished(report);
                this.returnState = 6;
                RestoreException rexc = new RestoreException(exc);
                new FrameworkLog(RestoreErrorIds._logInfo, 517, rexc).log();
                throw rexc;
            }
            finally {
                this.releaseLock(this.restoreDevice);
            }
        }
        Trace.trace(TRACE_MASKT, "<- RestoreImpl.restore()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean deleteFlagFile() {
        boolean deletedFile;
        block11: {
            MediaDevice upgradeDevice;
            block10: {
                Trace.trace(TRACE_MASKT, "-> RestoreImpl.deleteFlagFile()");
                upgradeDevice = null;
                deletedFile = true;
                MediaServices ms = MediaServices.getMediaServices();
                MediaDeviceIdentifier upgradeMediaId = ms.getPreferredDevice(4);
                upgradeDevice = ms.requestLock(new LocalizableText("Restore Critical Console Data"), upgradeMediaId);
                Trace.trace(TRACE_MASKF, "Mountpoint is: " + upgradeDevice.getMountPoint().toString());
                Trace.trace(TRACE_MASKF, "Upgrade partition is: " + this.restoreParameters.getParm("upgrade.partition"));
                if (!upgradeDevice.getMountPoint().toString().equals(this.restoreParameters.getParm("upgrade.partition"))) {
                    throw new RestoreException("wrong partition");
                }
                upgradeDevice.mountReadWrite();
                File flagFileL = new File(this.restoreParameters.getParm("upgrade.partition") + "/" + this.restoreParameters.getParm("restore.flag").toLowerCase());
                Trace.trace(TRACE_MASKF, "flag file lower case name is: " + flagFileL.getAbsolutePath());
                File flagFileU = new File(this.restoreParameters.getParm("upgrade.partition") + "/" + this.restoreParameters.getParm("restore.flag").toUpperCase());
                Trace.trace(TRACE_MASKF, "flag file upper case name is: " + flagFileU.getAbsolutePath());
                if (flagFileL.exists() && !flagFileL.delete()) {
                    deletedFile = false;
                }
                if (!flagFileU.exists() || flagFileU.delete()) break block10;
                deletedFile = false;
            }
            Object var8_8 = null;
            Trace.trace(TRACE_MASKF, "doing final release on upgrade partition");
            try {
                this.releaseLock(upgradeDevice);
            }
            catch (Exception exc) {
                this.returnState = 1;
                RestoreException rexc = new RestoreException(exc);
                new FrameworkLog(RestoreErrorIds._logInfo, 517, rexc).log();
            }
            break block11;
            {
                catch (Exception e) {
                    deletedFile = false;
                    Object var8_9 = null;
                    Trace.trace(TRACE_MASKF, "doing final release on upgrade partition");
                    try {
                        this.releaseLock(upgradeDevice);
                    }
                    catch (Exception exc) {
                        this.returnState = 1;
                        RestoreException rexc = new RestoreException(exc);
                        new FrameworkLog(RestoreErrorIds._logInfo, 517, rexc).log();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                Trace.trace(TRACE_MASKF, "doing final release on upgrade partition");
                try {
                    this.releaseLock(upgradeDevice);
                }
                catch (Exception exc) {
                    this.returnState = 1;
                    RestoreException rexc = new RestoreException(exc);
                    new FrameworkLog(RestoreErrorIds._logInfo, 517, rexc).log();
                }
                throw throwable;
            }
        }
        Trace.trace(TRACE_MASKT, "<- RestoreImpl.deletedFlagFile()");
        return deletedFile;
    }

    LocalizableText getMediaName() {
        return this.mediaName;
    }

    int getState() {
        return this.returnState;
    }

    private void releaseLock(MediaDevice device) {
        try {
            device.unlock();
        }
        catch (MediaDeviceLockException e) {
            new FrameworkLog(RestoreErrorIds._logInfo, 517, e).log();
        }
    }
}

